# R Machine learning Code:
library(mlr3verse)
library(readr)
# import dataset
# need to specify full path for PowerBI:
df_sales <- 
  read_csv('C:/Users/evancarey/Dropbox/Work/BHAnalytics/courseware/PowerBI/PowerBI_R/PredAnalyticsWebinar/data/customer_sales1.csv')
# first define task
#### Define data task #### 
## first must change date to numeric
df_sales$transaction_Date <- as.numeric(df_sales$transaction_Date)
df_sales$sale <- factor(df_sales$sale)
## remove the sale amount since it tells us sale
df_sales$sale_amount <- NULL
## now we create task
task <- 
  as_task_classif(df_sales, 
                  target='sale',
                  id='sales')
# pick the best model and make predictions
learner <- lrn("classif.log_reg",predict_type = "prob")
learner$train(task)

# now make predictions 
predictions_df <- 
  as.data.table(learner$predict(task))
df_sales$predicted_Sale <-
  predictions_df$prob.Yes

